/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

class Es6TemplateLiterals {
    private static final String TEMPLATELIT_VAR = "$jscomp$templatelit$";

    Es6TemplateLiterals() {
    }

    static void visitTemplateLiteral(NodeTraversal t, Node n, boolean addTypes) {
        JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
        JSType stringType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.STRING_TYPE);
        int length = n.getChildCount();
        if (length == 0) {
            n.replaceWith(Es6ToEs3Util.withType(IR.string("\"\""), stringType));
        } else {
            Node first = n.removeFirstChild();
            Preconditions.checkState(first.isTemplateLitString() && first.getCookedString() != null);
            Node firstStr = Es6ToEs3Util.withType(IR.string(first.getCookedString()), stringType);
            if (length == 1) {
                n.replaceWith(firstStr);
            } else {
                Node add = Es6ToEs3Util.withType(IR.add(firstStr, n.removeFirstChild().removeFirstChild()), n.getJSType());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isTemplateLitString()) {
                        Preconditions.checkState(child.getCookedString() != null);
                        if (child.getCookedString().isEmpty()) continue;
                        if (i == 2 && first.getCookedString().isEmpty()) {
                            add = add.getSecondChild().detach();
                        }
                    }
                    add = Es6ToEs3Util.withType(IR.add(add, child.isTemplateLitString() ? Es6ToEs3Util.withType(IR.string(child.getCookedString()), stringType) : child.removeFirstChild()), n.getJSType());
                }
                n.replaceWith(add.useSourceInfoIfMissingFromForTree(n));
            }
        }
        t.reportCodeChange();
    }

    static void visitTaggedTemplateLiteral(NodeTraversal t, Node n, boolean addTypes) {
        Node defineRaw;
        AstFactory astFactory = t.getCompiler().createAstFactory();
        JSTypeRegistry registry = t.getCompiler().getTypeRegistry();
        JSType stringType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.STRING_TYPE);
        JSType arrayType = Es6ToEs3Util.createGenericType(addTypes, registry, JSTypeNative.ARRAY_TYPE, stringType);
        JSType templateArrayType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.I_TEMPLATE_ARRAY_TYPE);
        JSType voidType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.VOID_TYPE);
        JSType numberType = Es6ToEs3Util.createType(addTypes, registry, JSTypeNative.NUMBER_TYPE);
        Node templateLit = n.getLastChild();
        Node cooked = Es6TemplateLiterals.createCookedStringArray(templateLit, templateArrayType, stringType, voidType, numberType);
        Node siteObject = Es6ToEs3Util.withType(cooked, templateArrayType);
        Node callsiteId = Es6ToEs3Util.withType(IR.name(TEMPLATELIT_VAR + t.getCompiler().getUniqueNameIdSupplier().get()), templateArrayType);
        Node var = IR.var(callsiteId, siteObject).useSourceInfoIfMissingFromForTree(n);
        Node script = NodeUtil.getEnclosingScript(n);
        script.addChildToFront(var);
        t.reportCodeChange(var);
        if (Es6TemplateLiterals.cookedAndRawStringsSame(templateLit)) {
            defineRaw = IR.exprResult(astFactory.createAssign(astFactory.createGetProp(callsiteId.cloneNode(), "raw"), astFactory.createCall(astFactory.createGetProp(callsiteId.cloneNode(), "slice"), new Node[0]))).useSourceInfoIfMissingFromForTree(n);
        } else {
            Node raw = Es6TemplateLiterals.createRawStringArray(templateLit, arrayType, stringType);
            defineRaw = IR.exprResult(astFactory.createAssign(astFactory.createGetProp(callsiteId.cloneNode(), "raw"), raw)).useSourceInfoIfMissingFromForTree(n);
        }
        script.addChildAfter(defineRaw, var);
        Node call = Es6ToEs3Util.withType(IR.call(n.removeFirstChild(), callsiteId.cloneNode()), n.getJSType());
        for (Node child = templateLit.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isTemplateLitString()) continue;
            call.addChildToBack(child.removeFirstChild());
        }
        call.useSourceInfoIfMissingFromForTree(templateLit);
        call.putBooleanProp(Node.FREE_CALL, !call.getFirstChild().isGetProp());
        n.replaceWith(call);
        t.reportCodeChange();
    }

    private static Node createRawStringArray(Node n, JSType arrayType, JSType stringType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), arrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            array.addChildToBack(Es6ToEs3Util.withType(IR.string(child.getRawString()), stringType));
        }
        return array;
    }

    private static Node createCookedStringArray(Node n, JSType templateArrayType, JSType stringType, JSType voidType, JSType numberType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), templateArrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            if (child.getCookedString() != null) {
                array.addChildToBack(Es6ToEs3Util.withType(IR.string(child.getCookedString()), stringType));
                continue;
            }
            array.addChildToBack(Es6ToEs3Util.withType(IR.voidNode(Es6ToEs3Util.withType(IR.number(0.0), numberType)), voidType));
        }
        return array;
    }

    private static boolean cookedAndRawStringsSame(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString() || child.getCookedString() != null && child.getCookedString().equals(child.getRawString())) continue;
            return false;
        }
        return true;
    }
}

