/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.jstype.AbstractDefaultValueVisitor;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.NamedType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.TemplateType;
import com.google.javascript.rhino.jstype.TemplatizedType;
import com.google.javascript.rhino.jstype.UnionType;
import java.util.AbstractMap;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;

class ContainsUpperBoundSuperTypeVisitor
extends AbstractDefaultValueVisitor<Result> {
    private final JSType target;
    private final AbstractMap<ProxyObjectType, Void> seen;
    static final Result FOUND = new Result(true, null);
    static final Result NOT_FOUND = new Result(false, null);

    public ContainsUpperBoundSuperTypeVisitor(JSType target) {
        super(NOT_FOUND);
        this.target = target;
        this.seen = new IdentityHashMap<ProxyObjectType, Void>();
    }

    @Override
    public Result caseTemplateType(TemplateType type) {
        return this.caseProxyObjectTypeHelper(type, type.getBound());
    }

    @Override
    public Result caseNamedType(NamedType type) {
        return this.caseProxyObjectTypeHelper(type, type.getReferencedType());
    }

    @Override
    public Result caseTemplatizedType(TemplatizedType type) {
        return this.caseProxyObjectTypeHelper(type, type.getReferencedType());
    }

    @Override
    public Result caseUnionType(UnionType type) {
        if (JSType.areIdentical(type, this.target)) {
            return FOUND;
        }
        for (JSType alt : type.getAlternates()) {
            Result foundInAlt = alt.visit(this);
            if (foundInAlt == NOT_FOUND) continue;
            return foundInAlt;
        }
        return NOT_FOUND;
    }

    private Result caseProxyObjectTypeHelper(ProxyObjectType type, JSType reference) {
        if (JSType.areIdentical(type, this.target)) {
            return FOUND;
        }
        if (this.seen.containsKey(type)) {
            return ContainsUpperBoundSuperTypeVisitor.cycle(type);
        }
        this.seen.put(type, null);
        return reference.visit(this);
    }

    static Result cycle(JSType type) {
        return new Result(false, type);
    }

    static class Result {
        boolean foundSupertype;
        @Nullable
        JSType cycle;

        Result(boolean foundSupertype, JSType cycle) {
            this.foundSupertype = foundSupertype;
            this.cycle = cycle;
        }
    }
}

